function [fitresult, gof] = edge_detection_surface_fit_pLux_cI(x1_log, y1_log, z1_log, second_input, starting_vals)
%CREATESURFACEFIT(X1_LOG,Y1_LOG,Z1_LOG)
%  Fit surface to data.
%
%  Data for 'untitled fit 1' fit:
%      X Input : x1_log
%      Y Input : y1_log
%      Z output: z1_log
%      Weights : (none)
%
%  Output:
%      fitresult : an sfit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, SFIT.

%  Auto-generated by MATLAB on 29-Mar-2011 22:12:39


%% Fit: 'untitled fit 1'.
ft = fittype( '(bottom1 + (top1 - bottom1) / (1+10^(LogEC50_1 - x))) * (bottom2 + (top2 - bottom2) / (1+10^(LogEC50_2 - y)))', 'indep', {'x', 'y'}, 'depend', 'z');
opts = fitoptions( ft);
opts.Algorithm = 'Levenberg-Marquardt'; %changing the algorithm leads to better fits
opts.Display = 'off';
opts.Lower   = [-Inf -Inf -Inf -Inf -Inf -Inf];
opts.Upper   = [Inf Inf Inf Inf Inf Inf];
opts.Weights = zeros(1,0);
%opts.StartPoint = [0.345565927376724 0.511142979027213 0.527232849483832 0.521533398083447 0.284479172477811 0.951406258730611];
%opts.StartPoint = [0.902694718955865 0.349082013525347 0.406954370962453 0.593423889585684 0.0507528367679441 0.410812148496715];
opts.StartPoint = starting_vals;
[fitresult, gof] = fit( [x1_log, y1_log], z1_log, ft, opts );

% Plot fit with data.
figure( 'Name', ['surface fit LacZ vs. AHL,' second_input] );
h = plot( fitresult, [x1_log, y1_log], z1_log );
grid on
% Label axes
xlabel( 'AHL' );
ylabel( second_input );
zlabel( 'LacZ' );
legend( h, 'pLux-CI', ['LacZ vs. AHL, ' second_input], 'Location', 'NorthEast' );
view( -47.5, 78 );


